//-------------------------------------------------
//          TestSuite: Critical
//-------------------------------------------------

#include "lcd.h"
#include "util.h"
#include "os_core.h"
#include "os_scheduler.h"

#include <avr/interrupt.h>
#include <avr/pgmspace.h>

#define DELAY 100

void crPrint(prog_char const* str) {
  char print[17];
  strlcpy_P(print,str,16);
  os_enterCriticalSection();
  size_t i = 0;
  char c;
  while ((c = print[i++])) {
    lcd_writeChar(c);
    delayMs(DELAY);
  }
  while (i++ <= 8) {
    lcd_writeChar(' ');
    delayMs(DELAY);
  }
  os_leaveCriticalSection();
  delayMs(4*DELAY);
}

PROGRAM(1, AUTOSTART) {
  for (;;)
    crPrint(PSTR("Hello "));
}

PROGRAM(2, AUTOSTART) {
  for (;;)
    crPrint(PSTR("World!"));
}
